#include "manette.h"

#ifndef JOUEUR_H
#define JOUEUR_H

#include "Cbob.h"
#include "Collide.h"
#include "CPartEmmit.h"

//Le joueur est un objet physique en mouvement
class CJoueur : public CCollideMv
{
    private:
        CbobOBJ mod;//modle orient
        float shield;//vie
        
        CManette *cMant;//manette de controle
        
        Vecteur rot;//angle de rotation
        Vecteur frot;//force de rotation
        
        CPartEmmit m1;//,m2; // un seul mteur de particule
        
        unsigned char bRL;//code de tire
        float timeShot,timeShotM;//temps entre 2 tire laser puis missile (M)
        
        unsigned int idCross;//identifiant de la list openGL de commande d'affichage de l'interface joueur
        
        unsigned short int ressus;//temps avant une rsurection
        float nitro;//quantit de nitro
        
        float secousse;//amplitude des seccousses.
        
    protected:
        
        virtual void applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg);
        virtual void applyExplosion(float dmg,float proxi);
        
        virtual bool frameMove(float elapsedTime);
        virtual void render();
        
    public:
        CJoueur();
        ~CJoueur();
        
        bool ressusiter(unsigned int elapsedTime);//fonction de test si rssusite
        void rendCross();//affichage de l'interface
        
        void initGraphX();//initialisation graphique (modle et cross)
        void clearGraphX();//libration graphique du modle
        
        float getMvmnt();//obtenir le dplacement du joueur
        void fixCam();//placer la camra suivant le joueur
        
        void translateCam();//n'appliquer que la position de la camra (pour dessiner la sky box)
        void setManette(CManette *cMant);//mettre une manette au joueur
        
        void getPtrCible(Vecteur *&p,Vecteur *&v);//retourne un pointeur sur la position et la vitesse du joueur
};

#endif
